/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.bmtr.core;

import java.util.ListIterator;
import java.util.function.Predicate;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import zabi.minecraft.bmtr.ModConfig;
import zabi.minecraft.bmtr.core.ASMException;

public class BaublesTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if ("baubles.api.BaubleType".equals(transformedName)) {
            return this.transformBaubleType(basicClass);
        }
        if ("baubles.api.cap.BaublesContainer".equals(transformedName)) {
            return this.transformBaublesContainer(basicClass);
        }
        if ("baubles.common.container.ContainerPlayerExpanded".equals(transformedName)) {
            return this.transformContainerPlayerExpanded(basicClass);
        }
        if ("baubles.common.event.EventHandlerEntity".equals(transformedName)) {
            return this.transformEventHandlerEntity(basicClass);
        }
        if ("baubles.client.gui.GuiPlayerExpanded".equals(transformedName)) {
            try {
                return this.transformGuiPlayerExpanded(basicClass);
            }
            catch (ASMException e) {
                System.err.println("Failed to transform GuiPlayerExpanded, ignoring as this is normal on a server");
                e.printStackTrace();
                return basicClass;
            }
        }
        if ("baubles.common.CommonProxy".equals(transformedName)) {
            return this.transformCommonProxy(basicClass);
        }
        return basicClass;
    }

    private byte[] transformEventHandlerEntity(byte[] basicClass) {
        ClassReader cr = new ClassReader(basicClass);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        MethodNode mn = BaublesTransformer.locateMethod(cn, "attachCapabilitiesPlayer");
        AbstractInsnNode inst = BaublesTransformer.locateTargetInsn(mn, n -> 187 == n.getOpcode() && ((TypeInsnNode)n).desc.equals("baubles/api/cap/BaublesContainer") && n.getNext().getNext().getOpcode() == 183);
        AbstractInsnNode constructor = inst.getNext().getNext();
        mn.instructions.insert(constructor, (AbstractInsnNode)new MethodInsnNode(183, "zabi/minecraft/bmtr/components/BaublesStackHandler", "<init>", "()V", false));
        mn.instructions.remove(constructor);
        mn.instructions.insert(inst, (AbstractInsnNode)new TypeInsnNode(187, "zabi/minecraft/bmtr/components/BaublesStackHandler"));
        mn.instructions.remove(inst);
        ClassWriter cw = new ClassWriter(3){

            protected String getCommonSuperClass(String type1, String type2) {
                System.out.println();
                return super.getCommonSuperClass(type1, type2);
            }
        };
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private byte[] transformCommonProxy(byte[] basicClass) {
        ClassReader cr = new ClassReader(basicClass);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        MethodNode mn = BaublesTransformer.locateMethod(cn, "getServerGuiElement");
        AbstractInsnNode node = BaublesTransformer.locateTargetInsn(mn, n -> n.getOpcode() == 187 && n.getNext().getOpcode() == 89);
        mn.instructions.insert(node, (AbstractInsnNode)new TypeInsnNode(187, "zabi/minecraft/bmtr/components/ContainerBaubles"));
        mn.instructions.remove(node);
        AbstractInsnNode initContainer = BaublesTransformer.locateTargetInsn(mn, n -> n.getOpcode() == 183 && ((MethodInsnNode)n).owner.equals("baubles/common/container/ContainerPlayerExpanded") && ((MethodInsnNode)n).name.equals("<init>"));
        mn.instructions.insert(initContainer, (AbstractInsnNode)new MethodInsnNode(183, "zabi/minecraft/bmtr/components/ContainerBaubles", "<init>", new String(((MethodInsnNode)initContainer).desc), false));
        mn.instructions.remove(initContainer);
        ClassWriter cw = new ClassWriter(3);
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private byte[] transformGuiPlayerExpanded(byte[] basicClass) {
        ClassReader cr = new ClassReader(basicClass);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        MethodNode mn = BaublesTransformer.locateMethod(cn, "<init>");
        AbstractInsnNode node = BaublesTransformer.locateTargetInsn(mn, n -> n.getOpcode() == 187 && n.getNext().getOpcode() == 89);
        mn.instructions.insert(node, (AbstractInsnNode)new TypeInsnNode(187, "zabi/minecraft/bmtr/components/ContainerBaubles"));
        mn.instructions.remove(node);
        AbstractInsnNode initContainer = BaublesTransformer.locateTargetInsn(mn, n -> n.getOpcode() == 183 && ((MethodInsnNode)n).owner.equals("baubles/common/container/ContainerPlayerExpanded") && ((MethodInsnNode)n).name.equals("<init>"));
        mn.instructions.insert(initContainer, (AbstractInsnNode)new MethodInsnNode(183, "zabi/minecraft/bmtr/components/ContainerBaubles", "<init>", new String(((MethodInsnNode)initContainer).desc), false));
        mn.instructions.remove(initContainer);
        ClassWriter cw = new ClassWriter(3);
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private byte[] transformContainerPlayerExpanded(byte[] basicClass) {
        ClassReader cr = new ClassReader(basicClass);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        MethodNode mn = BaublesTransformer.locateMethod(cn, "<init>");
        AbstractInsnNode ain = BaublesTransformer.locateTargetInsn(mn, n -> n.getOpcode() == 16 && n.getNext().getOpcode() == 16 && n.getNext().getNext().getOpcode() == 16 && ((IntInsnNode)n).operand == 6);
        while (ain.getOpcode() != 87) {
            ain = ain.getNext();
        }
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new IntInsnNode(25, 0));
        list.add((AbstractInsnNode)new IntInsnNode(25, 3));
        list.add((AbstractInsnNode)new MethodInsnNode(184, "zabi/minecraft/bmtr/core/Snippets", "addSlotsToContainer", "(Lbaubles/common/container/ContainerPlayerExpanded;Ljava/lang/Object;)V", false));
        mn.instructions.insert(ain, list);
        ClassWriter cw = new ClassWriter(3);
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private byte[] transformBaublesContainer(byte[] basicClass) {
        ClassReader cr = new ClassReader(basicClass);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        this.transformConstant(cn);
        this.transformConstructor(cn);
        this.transformSetSize(cn);
        ClassWriter cw = new ClassWriter(3);
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private void transformSetSize(ClassNode cn) {
        MethodNode mn = BaublesTransformer.locateMethod(cn, "(I)V", "setSize");
        AbstractInsnNode l0 = BaublesTransformer.locateTargetInsn(mn, n -> n instanceof LabelNode);
        AbstractInsnNode l1 = BaublesTransformer.locateTargetInsn(mn, n -> n instanceof LabelNode && !((LabelNode)n).getLabel().equals(((LabelNode)l0).getLabel()));
        while (!l0.getNext().equals(l1)) {
            mn.instructions.remove(l0.getNext());
        }
    }

    private void transformConstructor(ClassNode cn) {
        MethodNode mn = BaublesTransformer.locateMethod(cn, "()V", "<init>");
        AbstractInsnNode bipush = BaublesTransformer.locateTargetInsn(mn, n -> n.getOpcode() == 16 && n.getNext().getOpcode() == 183);
        mn.instructions.insert(bipush, (AbstractInsnNode)new IntInsnNode(16, 7 + ModConfig.getExtraSlots()));
        mn.instructions.remove(bipush);
        AbstractInsnNode arraySizeNode = BaublesTransformer.locateTargetInsn(mn, n -> n.getOpcode() == 16 && n.getNext().getOpcode() == 188);
        mn.instructions.insert(arraySizeNode, (AbstractInsnNode)new IntInsnNode(16, 7 + ModConfig.getExtraSlots()));
        mn.instructions.remove(arraySizeNode);
    }

    private void transformConstant(ClassNode cn) {
        FieldNode fn = cn.fields.parallelStream().filter(f -> "BAUBLE_SLOTS".equals(f.name)).findFirst().orElseThrow(() -> new ASMException("Can't find field BAUBLE_SLOTS"));
        fn.value = ModConfig.getExtraSlots();
    }

    private byte[] transformBaubleType(byte[] basicClass) {
        ClassReader cr = new ClassReader(basicClass);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        MethodNode mn = BaublesTransformer.locateMethod(cn, "()V", "<clinit>");
        this.addRings(mn);
        this.addTrinkets(mn);
        this.addAll(mn, "AMULET", 0);
        this.addAll(mn, "BELT", 3);
        this.addAll(mn, "HEAD", 4);
        this.addAll(mn, "BODY", 5);
        this.addAll(mn, "CHARM", 6);
        ClassWriter cw = new ClassWriter(3);
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private void addAll(MethodNode mn, String type, int operand) {
        operand = 7;
        AbstractInsnNode arraysizeNode = BaublesTransformer.locateTargetInsn(mn, n -> n.getOpcode() == 18 && ((LdcInsnNode)n).cst.equals(type)).getNext().getNext();
        mn.instructions.insert(arraysizeNode, (AbstractInsnNode)new IntInsnNode(16, operand + ModConfig.getExtraSlots()));
        mn.instructions.remove(arraysizeNode);
        AbstractInsnNode init = BaublesTransformer.locateTargetInsn(mn, n -> n.getOpcode() == 183 && ((MethodInsnNode)n).name.equals("<init>") && ((MethodInsnNode)n).desc.equals("(Ljava/lang/String;I[I)V") && n.getNext().getOpcode() == 179 && ((FieldInsnNode)n.getNext()).name.equals(type));
        InsnList initArrayInsns = new InsnList();
        for (int i = operand; i < operand + ModConfig.getExtraSlots(); ++i) {
            initArrayInsns.add((AbstractInsnNode)new InsnNode(89));
            initArrayInsns.add((AbstractInsnNode)new IntInsnNode(16, i));
            initArrayInsns.add((AbstractInsnNode)new IntInsnNode(16, i));
            initArrayInsns.add((AbstractInsnNode)new InsnNode(79));
        }
        mn.instructions.insertBefore(init, initArrayInsns);
    }

    private void addTrinkets(MethodNode mn) {
        AbstractInsnNode arraysizeNode = BaublesTransformer.locateTargetInsn(mn, n -> n.getOpcode() == 18 && ((LdcInsnNode)n).cst.equals("TRINKET")).getNext().getNext();
        mn.instructions.insert(arraysizeNode, (AbstractInsnNode)new IntInsnNode(16, 7 + ModConfig.getExtraSlots()));
        mn.instructions.remove(arraysizeNode);
        AbstractInsnNode init = BaublesTransformer.locateTargetInsn(mn, n -> n.getOpcode() == 183 && ((MethodInsnNode)n).name.equals("<init>") && ((MethodInsnNode)n).desc.equals("(Ljava/lang/String;I[I)V") && n.getNext().getOpcode() == 179 && ((FieldInsnNode)n.getNext()).name.equals("TRINKET"));
        InsnList initArrayInsns = new InsnList();
        for (int i = 7; i < 7 + ModConfig.getExtraSlots(); ++i) {
            initArrayInsns.add((AbstractInsnNode)new InsnNode(89));
            initArrayInsns.add((AbstractInsnNode)new IntInsnNode(16, i));
            initArrayInsns.add((AbstractInsnNode)new IntInsnNode(16, i));
            initArrayInsns.add((AbstractInsnNode)new InsnNode(79));
        }
        mn.instructions.insertBefore(init, initArrayInsns);
    }

    private void addRings(MethodNode mn) {
        AbstractInsnNode arraysizeNode = BaublesTransformer.locateTargetInsn(mn, n -> n.getOpcode() == 18 && ((LdcInsnNode)n).cst.equals("RING")).getNext().getNext();
        mn.instructions.insert(arraysizeNode, (AbstractInsnNode)new IntInsnNode(16, 2 + ModConfig.getExtraSlots()));
        mn.instructions.remove(arraysizeNode);
        AbstractInsnNode init = BaublesTransformer.locateTargetInsn(mn, n -> n instanceof MethodInsnNode && ((MethodInsnNode)n).name.equals("<init>") && ((MethodInsnNode)n).desc.equals("(Ljava/lang/String;I[I)V") && n.getNext().getOpcode() == 179 && ((FieldInsnNode)n.getNext()).name.equals("RING"));
        InsnList initArrayInsns = new InsnList();
        for (int i = 2; i < 2 + ModConfig.getExtraSlots(); ++i) {
            initArrayInsns.add((AbstractInsnNode)new InsnNode(89));
            initArrayInsns.add((AbstractInsnNode)new IntInsnNode(16, i));
            initArrayInsns.add((AbstractInsnNode)new IntInsnNode(16, i + 5));
            initArrayInsns.add((AbstractInsnNode)new InsnNode(79));
        }
        mn.instructions.insertBefore(init, initArrayInsns);
    }

    private static MethodNode locateMethod(ClassNode cn, String desc, String nameIn) {
        return cn.methods.parallelStream().filter(n -> n.desc.equals(desc) && n.name.equals(nameIn)).findAny().orElseThrow(() -> new ASMException(nameIn + ": " + desc + " cannot be found in " + cn.name, cn));
    }

    private static MethodNode locateMethod(ClassNode cn, String nameIn) {
        return cn.methods.parallelStream().filter(n -> n.name.equals(nameIn)).findAny().orElseThrow(() -> new ASMException(nameIn + " cannot be found in " + cn.name, cn));
    }

    private static AbstractInsnNode locateTargetInsn(MethodNode mn, Predicate<AbstractInsnNode> filter) {
        AbstractInsnNode target = null;
        ListIterator i = mn.instructions.iterator();
        while (i.hasNext() && target == null) {
            AbstractInsnNode n = (AbstractInsnNode)i.next();
            if (!filter.test(n)) continue;
            target = n;
        }
        if (target == null) {
            throw new ASMException("Can't locate target instruction in " + mn.name, mn);
        }
        return target;
    }
}

